#ifndef CE2_XTS_AES_H
#define CE2_XTS_AES_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CryptoEngine2.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object % CE2_XTS_AES.h    : %
   *  State           :  %state%
   *  Creation date   :  2007.07.20
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions that are used for the 
   *         CE2 XTS-AES APIs, as well as the APIs themselves. 
   *
   *  \version CE2_XTS_AES.h#1:incl:13
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/
/************************ Enums ********************************/
/************************ Typedefs  ****************************/
/************************ Public Variables **********************/
/************************ Public Functions **********************/                    

/**
****************************************************************
* Function Name: 
*  DX_XTS_AES
*
* @param Key1_ptr [in] - This parameter is a first AES key used for XTS-AES cipher.
* @param Key2_ptr [in] - This parameter is a second AES key used for XTS-AES cipher.
* @param KeySize [in] - Size of first and second AES keys.
* @param SectorNumber [in] - 64-bit sector number.
* @param EncryptDecryptFlag [in] - This flag specialize encrypt or decrypt operation.
* @param DataIn_ptr [in] - A pointer to input data.
* @param DataInSize [in] - Size of input data. It must be at least 16 bytes.
* @param DataOut_ptr [out] - A pointer to output data.
*
* @returns \b
*  CE2Error_t 
*  - CE2_OK - on success
*  - Otherwise - error code:
*   - CE2_XTS_AES_ILLEGAL_KEY1_PTR_ERROR
*   - CE2_XTS_AES_ILLEGAL_KEY2_PTR_ERROR
*   - CE2_XTS_AES_ILLEGAL_KEY_SIZE_ERROR
*   - CE2_XTS_AES_ILLEGAL_ENCRYPT_MODE_ERROR
*   - CE2_XTS_AES_ILLEGAL_DATAIN_PTR_ERROR
*   - CE2_XTS_AES_TO_SHORT_DATA_SIZE_ERROR
*   - CE2_XTS_AES_ILLEGAL_DATAOUT_PTR_ERROR
*
* \brief \b 
* Description:
*  This function is used to make XTS-AES operations;
*
*  \b 
* Algorithm:
*  -# Verify input parameters;
*  -# Call low level function LLF_XTS_AES().
***************************************************************/
CIMPORT_C CE2Error_t DX_XTS_AES(CE2_AES_Key_t           Key1_ptr,
															  CE2_AES_Key_t           Key2_ptr,
															  CE2_AES_KeySize_t       KeySize,
															  DxUint64_t							SectorNumber,
															  CE2_AES_EncryptMode_t   EncryptDecryptFlag, 
															  DxUint8_t               *DataIn_ptr,        
															  DxUint32_t              DataInSize,         
															  DxUint8_t               *DataOut_ptr);     

#ifdef __cplusplus
}
#endif

#endif
